<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:rpr="relativePathResolverPrefix">

<xsl:template name="diagramFilename">
	<xsl:param name="diagram"/>
	
	<xsl:value-of select="$diagram/@file"/>
	<!--xsl:variable name="meta">
		<xsl:value-of select="$diagram/@metaclass"/>
	</xsl:variable>
	
	<xsl:variable name="prefix">
		<xsl:choose>
			<xsl:when test="$meta='Class Diagram'"><xsl:value-of select="'CL_'"/></xsl:when>
			<xsl:when test="$meta='Use Case Diagram'"><xsl:value-of select="'UC_'"/></xsl:when>
			<xsl:when test="$meta='Sequence Diagram'"><xsl:value-of select="'SQ_'"/></xsl:when>
			<xsl:when test="$meta='Communication Diagram'"><xsl:value-of select="'CD_'"/></xsl:when>
			<xsl:when test="$meta='State Machine Diagram'"><xsl:value-of select="'SC_'"/></xsl:when>
			<xsl:when test="$meta='Activity Diagram'"><xsl:value-of select="'AV_'"/></xsl:when>
			<xsl:when test="$meta='Component Diagram'"><xsl:value-of select="'CM_'"/></xsl:when>
			<xsl:when test="$meta='Deployment Diagram'"><xsl:value-of select="'DD_'"/></xsl:when>
			<xsl:when test="$meta='Composite Structure Diagram'"><xsl:value-of select="'CS_'"/></xsl:when>
			
			<xsl:when test="$meta='Package Diagram'"><xsl:value-of select="DF_"/></xsl:when>
			<xsl:when test="$meta='Collaboration Diagram'"><xsl:value-of select="'CD_'"/></xsl:when>
			<xsl:when test="$meta='Statechart Diagram'"><xsl:value-of select="'SC_'"/></xsl:when>
			<xsl:when test="$meta='Sequence Diagram'"><xsl:value-of select="'SQ_'"/></xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="''"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:value-of select="concat($prefix, string($diagram/@name))"/-->
</xsl:template>

<!-- returtns relative path to the element -->
	<xsl:template name="RelPathResolver">
		<xsl:param name="element"></xsl:param>
		
		<xsl:variable name="localName" select="local-name($element)"/>
		<xsl:variable name="resPath">
			<xsl:choose>
				<!-- Package -->
				<xsl:when test="$localName='Package'">
					<xsl:variable name="relativePath">
						<xsl:apply-templates select="$element" mode="getRelativePath"></xsl:apply-templates>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="$relativePath">
							<xsl:value-of select="concat($relativePath, '/package-summary.html')"></xsl:value-of>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'package-summary.html'"></xsl:value-of>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				
				<!-- Diagram -->
				<xsl:when test="$localName='Diagram'">
					<!--xsl:variable name="name" select="concat($dprefix, string($element/@name))"></xsl:variable-->
					<xsl:variable name="name">
						<xsl:call-template name="diagramFilename">
							<xsl:with-param name="diagram" select="$element"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:variable name="package" select="$element/.."></xsl:variable>
					<xsl:variable name="relativePath">
						<xsl:apply-templates select="$package" mode="getRelativePath"></xsl:apply-templates>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($relativePath) &gt; 0">
							<!--xsl:value-of select="concat($relativePath, '/', $name, '.html')"></xsl:value-of-->
							<xsl:value-of select="concat($relativePath, '/', $name)"></xsl:value-of>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$name"></xsl:value-of>
							<!--xsl:value-of select="concat($name, '.html')"></xsl:value-of-->
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				
				<!-- DesignElement -->
				<xsl:when test="$localName='DesignElement'">
					<xsl:choose>
						<xsl:when test="$viewType='diagram'">
							<xsl:variable name="elementRef">
								<xsl:apply-templates select="$element" mode="unique_reference"></xsl:apply-templates>
							</xsl:variable>
							<xsl:variable name="id" select="string($element/@id)"></xsl:variable>
							<xsl:variable name="diagram" select="(//Diagram//DiagramReference[@element=$id]/ancestor::Diagram)[position()=last()]"></xsl:variable>
							<xsl:variable name="relPath">
								<xsl:call-template name="RelPathResolver">
									<xsl:with-param name="element" select="$diagram"></xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:value-of select="concat($relPath, '#', $elementRef)"/>
						</xsl:when>
						<xsl:otherwise>
							<!-- $viewType = "'model'" -->
							<xsl:variable name="elementRef">
								<xsl:apply-templates select="$element" mode="unique_reference"></xsl:apply-templates>
							</xsl:variable>
							<xsl:variable name="ppackagepath">
								<xsl:call-template name="RelPathResolver">
									<xsl:with-param name="element" select="($element/ancestor::Model | $element/ancestor::Package)[position()=last()]"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:value-of select="concat($ppackagepath, '#', $elementRef)"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<!-- Field -->
				<xsl:when test="$localName='Field'">
					<xsl:variable name="name" select="string($element/@elementName)"></xsl:variable>
					<xsl:variable name="class" select="$element/.."></xsl:variable>
					<xsl:variable name="relPath">
						<xsl:call-template name="RelPathResolver">
							<xsl:with-param name="element" select="$class"></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of select="concat($relPath, '#', $name)"></xsl:value-of>
				</xsl:when>

				<!-- Method -->
				<xsl:when test="$localName='Method'">
					<xsl:variable name="inner-ref">
						<xsl:apply-templates select="$element" mode="method-ref"></xsl:apply-templates>
					</xsl:variable>
					<xsl:variable name="class" select="$element/.."></xsl:variable>
					<xsl:variable name="relPath">
						<xsl:call-template name="RelPathResolver">
							<xsl:with-param name="element" select="$class"></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of select="concat($relPath, '#', $inner-ref)"></xsl:value-of>
				</xsl:when>
				
				<!-- Model -->
				<xsl:when test="$localName='Model'">
					<!--xsl:variable name="name" select="string($element/@name)"></xsl:variable-->
					<xsl:variable name="relPath">
						<xsl:apply-templates select="$element" mode="getRelativePath"/>
					</xsl:variable>
					<xsl:choose>
						<xsl:when test="string-length($relPath) &gt; 0">
							<xsl:value-of select="concat($relPath, 'package-summary.html')"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'package-summary.html'"></xsl:value-of>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>

				<!--Classifier -->
				<xsl:otherwise>
					<xsl:variable name="relPath">
						<xsl:apply-templates select="$element" mode="getRelativePath"></xsl:apply-templates>
					</xsl:variable>
					<xsl:value-of select="concat($relPath, '.html')"></xsl:value-of>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="$resPath"></xsl:value-of>
	</xsl:template>
	
	<!-- Provides full path to element's doc -->
	<xsl:template name="pathResolver">
		<xsl:param name="element"></xsl:param>

		<!-- Figure out local name -->
		<xsl:variable name="localName" select="local-name($element)"></xsl:variable>
		<xsl:choose>

			<!-- Package -->
			<xsl:when test="$localName='Package'">
				<xsl:variable name="fullPath">
					<xsl:apply-templates select="$element" mode="getFullPath"></xsl:apply-templates>
				</xsl:variable>
				<xsl:value-of select="concat('file:///', $fullPath, '/package-summary.html')"></xsl:value-of>
			</xsl:when>
			
			<!-- Diagram -->
			<xsl:when test="$localName='Diagram'">
				<xsl:variable name="name" select="string($element/@name)"></xsl:variable>
				<xsl:variable name="package" select="$element/.."></xsl:variable>
				<xsl:variable name="fullPath">
					<xsl:apply-templates select="$package" mode="getFullPath"></xsl:apply-templates>
				</xsl:variable>
				<xsl:value-of select="concat('file:///', $fullPath, '/', $name, '.html')"></xsl:value-of>
			</xsl:when>

			<!-- DesignElement -->
			<xsl:when test="$localName='DesignElement'">
				<!--xsl:variable name="name" select="string($element/@name)"></xsl:variable-->
				<xsl:variable name="elementRef">
					<xsl:apply-templates select="$element" mode="unique_reference"></xsl:apply-templates>
				</xsl:variable>
				<xsl:variable name="id" select="string($element/@id)"></xsl:variable>
				<xsl:variable name="diagram" select="(//Diagram//DiagramReference[@element=$id]/ancestor::Diagram)[position()=last()]"></xsl:variable>
				<xsl:variable name="fullPath">
					<xsl:call-template name="pathResolver">
						<xsl:with-param name="element" select="$diagram"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<!--xsl:value-of select="concat($fullPath, '#', $name)"></xsl:value-of-->
				<xsl:value-of select="concat($fullPath, '#', $elementRef)"></xsl:value-of>
			</xsl:when>

			<!-- Field -->
			<xsl:when test="$localName='Field'">
				<xsl:variable name="name" select="string($element/@elementName)"></xsl:variable>
				<xsl:variable name="class" select="$element/.."></xsl:variable>
				<xsl:variable name="fullPath">
					<xsl:call-template name="pathResolver">
						<xsl:with-param name="element" select="$class"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($fullPath, '#', $name)"></xsl:value-of>
			</xsl:when>

			<!-- Method -->
			<xsl:when test="$localName='Method'">
				<xsl:variable name="inner-ref">
					<xsl:apply-templates select="$element" mode="method-ref"></xsl:apply-templates>
				</xsl:variable>
				<xsl:variable name="class" select="$element/.."></xsl:variable>
				<xsl:variable name="fullPath">
					<xsl:call-template name="pathResolver">
						<xsl:with-param name="element" select="$class"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="concat($fullPath, '#', $inner-ref)"></xsl:value-of>
			</xsl:when>
			
			<!-- Model -->
			<xsl:when test="$localName='Model'">
				<xsl:variable name="name" select="string($element/@name)"></xsl:variable>
				<xsl:value-of select="'package-summary.html'"></xsl:value-of>
			</xsl:when>

			<!--Classifier -->
			<xsl:otherwise>
				<xsl:variable name="fullPath">
					<xsl:apply-templates select="$element" mode="getFullPath"></xsl:apply-templates>
				</xsl:variable>
				<xsl:value-of select="concat('file:///', $fullPath, '.html')"></xsl:value-of>
			</xsl:otherwise>

		</xsl:choose>
	</xsl:template>


	<!-- Provide reference to doc-files/diagram.html -->
	<xsl:template name="DiagramMapPath">
		<xsl:param name="element"></xsl:param>

		<xsl:variable name="name">
			<xsl:call-template name="diagramFilename">
				<xsl:with-param name="diagram" select="$element"/>
			</xsl:call-template>
		</xsl:variable>
		<!--xsl:variable name="name" select="string($element/@name)"></xsl:variable-->
		<xsl:variable name="package" select="$element/.."></xsl:variable>
		<xsl:variable name="fullPath">
			<!--xsl:apply-templates select="$package" mode="getFullPath"></xsl:apply-templates-->
			<xsl:apply-templates select="$package" mode="getRelativePath"></xsl:apply-templates>
		</xsl:variable>
		<!--xsl:value-of select="concat('file:///', $fullPath, '/doc-files/', $name, '.html')"></xsl:value-of-->
		<xsl:choose>
			<xsl:when test="string-length($fullPath) &gt; 0">
				<!--xsl:value-of select="concat($fullPath, '/doc-files/', $name, '.html')"></xsl:value-of-->
				<xsl:value-of select="concat($fullPath, '/doc-files/', $name)"></xsl:value-of>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat('doc-files/', $name)"></xsl:value-of>
				<!--xsl:value-of select="concat('doc-files/', $name, '.html')"></xsl:value-of-->
			</xsl:otherwise>
		</xsl:choose>
		
	</xsl:template>

	
	<!-- Refrence to package-frame.html -->
	<xsl:template name="PackageFramePath">
		<xsl:param name="element"></xsl:param>
		<xsl:variable name="fullPath">
			<!--xsl:apply-templates select="$element" mode="getFullPath"></xsl:apply-templates-->
			<xsl:apply-templates select="$element" mode="getRelativePath"></xsl:apply-templates>
		</xsl:variable>
		<!--xsl:value-of select="concat('file:///', $fullPath, '/package-frame.html')"></xsl:value-of-->
		<xsl:choose>
			<xsl:when test="string-length($fullPath) &gt; 0">
				<xsl:value-of select="concat($fullPath, '/package-frame.html')"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'package-frame.html'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<!-- Print properties list -->
	<xsl:template name="printProperties">
			<xsl:param name="element"></xsl:param>
			<xsl:param name="nodeset"></xsl:param>
			<xsl:param name="property-names"></xsl:param>
			
			<xsl:variable name="first" select="$property-names[1]"></xsl:variable>
			<xsl:if test="$first">
	
			<xsl:variable name="p_name" select="string($first)"></xsl:variable>

			<!--xsl:variable name="filter" select="'Folder, Params, shortType, ReturnTypeName, ExtendsText, ImplementsText, ReturnValue, Namespace, TypeName, Package, ExtendsText, @link, TypeRefElement, Getter, Setter, ImplementsText, Implements, Visibility, ReturnTypeRefElement, Collab_foreground_color, Collab_Width, Collab_background_color, Collab_Left, Collab_Height, Collab_Top, Seq_Left, Seq_Top, Seq_background_color, Seq_Width, Seq_Height, Seq_foreground_color, Collab_LinkPoints, Seq_LinkPoints, Seq_UserSize, Collab_UserSize, Signature, url, defaultDiagram'"></xsl:variable-->
			<xsl:variable name="filter" select="'Folder, Params, Visibility, Namespace, Package, @link, Getter, Setter, Extends, Implements, Collab_foreground_color, Collab_Width, Collab_background_color, Collab_Left, Collab_Height, Collab_Top, Seq_Left, Seq_Top, Seq_background_color, Seq_Width, Seq_Height, Seq_foreground_color, Collab_LinkPoints, Seq_LinkPoints, Seq_UserSize, Collab_UserSize, url, defaultDiagram'"></xsl:variable>

				<!-- Filter out known properties-->
				<xsl:if test="not(contains($filter,$p_name))">
					<xsl:if test="not($p_name='Constructor')">
						<dl>
							<dt/>

							<xsl:choose>
								<!-- list of property values (with transformation for CaliberRM) -->
								<xsl:when test="$p_name='__req'">
									<xsl:variable name="req_text">
										<xsl:call-template name="getLocalizedResource">
											<xsl:with-param name="code" select="'requirement_text'"/>
										</xsl:call-template>
									</xsl:variable>
									<!--b><xsl:text>Requirement</xsl:text></b-->
									<b><xsl:value-of select="$req_text"/></b>
									<xsl:for-each select="$element/Property[@name=$p_name]">
										<dd>
										<!-- _req property format: requirement://CaliberRM_5.1:01@10.7.112.84/Automated Teller Machine/Cash Depletion Rate?csharp:e_class:src:WindowsApplication5:Class1#100 -->
										<xsl:variable name="value" select="."/>
										<xsl:variable name="server" select='substring-before(substring-after($value,"@"),"/")'/>
										<xsl:variable name="project" select='substring-before(substring-after($value,concat($server,"/")),"/")'/>
										<xsl:variable name="req" select='substring-before(substring-after($value,concat($project,"/")),"?")'/>
										<xsl:variable name="id" select='substring-after($value,"#")'/>
										<xsl:call-template name="getLocalizedResource">
											<xsl:with-param name="code" select="'requirement_format'"/>
											<xsl:with-param name="p1" select="$id"/>
											<xsl:with-param name="p2" select="$req"/>
											<xsl:with-param name="p3" select="$project"/>
											<xsl:with-param name="p4" select="$server"/>
										</xsl:call-template>
										<!--xsl:value-of select='concat("id: ",$id,", name: ",$req,", project: ",$project,", server: ",$server)'/-->
										</dd>
									</xsl:for-each>
								</xsl:when>
								<!-- usually property -->
								<xsl:otherwise>
									<b><xsl:value-of select="$p_name"/></b>
									<xsl:for-each select="$element/Property[@name=$p_name]">
										<dd>
											<xsl:choose>
												<xsl:when test="contains(string(current()), '&#xD;&#xA;')">
													<xsl:call-template name="replace">
														<xsl:with-param name="source" select="."/>
														<xsl:with-param name="what" select="'&#xD;&#xA;'"/>
														<xsl:with-param name="with" select="'&lt;br/&gt;'"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:when test="contains(string(current()), '&#xA;&#xD;')">
													<xsl:call-template name="replace">
														<xsl:with-param name="source" select="."/>
														<xsl:with-param name="what" select="'&#xA;&#xD;'"/>
														<xsl:with-param name="with" select="'&lt;br/&gt;'"/>
													</xsl:call-template>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="."/>
												</xsl:otherwise>
											</xsl:choose>
										</dd>
									</xsl:for-each>
								</xsl:otherwise>
							</xsl:choose>

						</dl>
					</xsl:if>
				</xsl:if>
			<xsl:call-template name="printProperties">
				<xsl:with-param name="element" select="$element"></xsl:with-param>
				<xsl:with-param name="nodeset" select="$nodeset"></xsl:with-param>
				<xsl:with-param name="property-names" select="$property-names[not(string($p_name)=string(.))]"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	
	</xsl:template>

	<!-- Calculates and returns relative prefix -->
	<xsl:template name="RelativePrefix">
		<xsl:param name="path"></xsl:param>
		<xsl:param name="prefix"></xsl:param>
		<xsl:variable name="path2">
			<xsl:call-template name="skipStartSlashes">
				<xsl:with-param name="str" select="$path"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="contains($path2, '/')">
				<xsl:call-template name="RelativePrefix">
					<xsl:with-param name="path" select="substring-after($path2, '/')"></xsl:with-param>
					<xsl:with-param name="prefix" select="concat($prefix, '../')"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$prefix"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="skipStartSlashes">
		<xsl:param name="str"></xsl:param>
		
		<xsl:choose>
			<xsl:when test="starts-with($str, '/')">
				<xsl:call-template name="skipStartSlashes">
					<xsl:with-param name="str" select="substring-after($str, '/')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$str"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="*" mode="getDescription">
		<xsl:value-of select="Property[@name='Description']"/>
	</xsl:template>
	
	<!-- Provides search for node in nodeset-->
	<xsl:template name="searchFor">
		<xsl:param name="where"></xsl:param>
		<xsl:param name="what"></xsl:param>
		<xsl:for-each select="$where">
			<xsl:if test="generate-id(.)=generate-id($what)">
				<xsl:value-of select="	true()"></xsl:value-of>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="getFQNInContext">
		<xsl:param name="element"></xsl:param>
		<xsl:param name="context"></xsl:param>
		
		<xsl:variable name="context_type" select="local-name($context)"></xsl:variable>
		<xsl:variable name="contextnamespace">
			<xsl:choose>
				<xsl:when test="($context_type='Package')or($context_type='Model')">
					<xsl:apply-templates select="$context" mode="getQualifiedName"></xsl:apply-templates>
				</xsl:when>
				<xsl:when test="$context_type='Classifier'">
					<xsl:apply-templates select="$context/.." mode="getQualifiedName"></xsl:apply-templates>
				</xsl:when>
				<xsl:when test="($context_type='Field')or($context_type='Method')">
					<xsl:apply-templates select="$context/../.." mode="getQualifiedName"></xsl:apply-templates>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="elementfqn">
			<xsl:apply-templates select="$element" mode="getQualifiedName"></xsl:apply-templates>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="not($elementfqn=concat($contextnamespace, '.', $element/@name))">
				<xsl:value-of select="$elementfqn"></xsl:value-of>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$element/@name"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="ImgLoaderScript">
		
		<script language="JavaScript">
			function doClick(imageHref) {
			if (parent.imageFrame != null)
				parent.imageFrame.location.href = imageHref;
			}
		</script>
	</xsl:template>
	
	<xsl:template match="*" mode="HRefWithImgLoad">
		<xsl:param name="isName"/>
		<xsl:param name="useName"/>
		<!-- 0 (default)= name, 1 = full qualified name (Classifier and Package only), 2 = external name (useName is used)-->
		
		<xsl:variable name="localName" select="local-name()"/>
		
		<xsl:variable name="elementsPath">
			<xsl:call-template name="RelPathResolver">
				<xsl:with-param name="element" select="self::node()"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="elementName">
			<xsl:choose>
				<xsl:when test="not($isName='2')">
					<xsl:if test="(local-name()='Classifier') and (@type='Interface')"><xsl:text disable-output-escaping="yes">&lt;i&gt;</xsl:text></xsl:if>
					<xsl:choose>
						<xsl:when test="$localName='Field'">
							<xsl:if test="$isName='1'">
								<xsl:apply-templates select="parent::node()" mode="getQualifiedName"/>
								<xsl:text>.</xsl:text>
							</xsl:if>
							<xsl:value-of select="@elementName"/>
						</xsl:when>
						<xsl:when test="$localName='Method'">
							<xsl:if test="$isName='1'">
								<xsl:apply-templates select="parent::node()" mode="getQualifiedName"/>
								<xsl:text>.</xsl:text>
							</xsl:if>
							<xsl:value-of select="@name"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="(($localName='Classifier') or ($localName='Package')) and ($isName='1')">
									<xsl:apply-templates select="self::node()" mode="getQualifiedName"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@name"/>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:if test="(local-name()='Classifier') and (@type='Interface')"><xsl:text disable-output-escaping="yes">&lt;/i&gt;</xsl:text></xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$useName"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<xsl:variable name="diagramMap">
			<xsl:text disable-output-escaping="yes">'</xsl:text>
			<xsl:choose>
				<xsl:when test="$localName='Model'">
					<xsl:call-template name="defaultDiagram"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="elementID">
						<xsl:choose>
							<xsl:when test="($localName='Field') or ($localName='Method')">
								<xsl:value-of select="../@id"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="@id"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					<xsl:variable name="package" select="(ancestor::Package)[position()=last()]"/>
					<xsl:choose>
						<xsl:when test="$package">
							<xsl:variable name="elemRef" select="$package//DiagramReference[(@element=$elementID) and not (@isShortcut='true')]"/>
							<xsl:variable name="diagram" select="Diagram/Property[@name='defaultDiagram']/parent::node()[$localName='Package'] | self::node()[$localName='Diagram'] | ($elemRef/ancestor::Diagram)[position()=last()][not(($localName='Package')or($localName='Diagram'))]"/>
							<xsl:if test="$diagram">
								<xsl:call-template name="DiagramMapPath">
									<xsl:with-param name="element" select="$diagram[1]"/>
								</xsl:call-template>
							</xsl:if>
						</xsl:when>
						<xsl:otherwise>
							<xsl:variable name="elemRef" select="//DiagramReference[(@element=$elementID) and not (@isShortcut='true')]"/>
							<xsl:variable name="diagram" select="Diagram/Property[@name='defaultDiagram']/parent::node()[$localName='Package'] | self::node()[$localName='Diagram'] | ($elemRef/ancestor::Diagram)[position()=last()][not(($localName='Package')or($localName='Diagram'))]"/>
							<xsl:if test="$diagram">
								<xsl:call-template name="DiagramMapPath">
									<xsl:with-param name="element" select="$diagram[1]"/>
								</xsl:call-template>
							</xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text disable-output-escaping="yes">'</xsl:text>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="string-length($diagramMap) &gt; 2">
				<xsl:text disable-output-escaping="yes">&lt;a href="</xsl:text><xsl:value-of select="$elementsPath"/><xsl:text disable-output-escaping="yes">" target="classFrame" onclick="doClick(</xsl:text><xsl:value-of select="$diagramMap"/><xsl:text disable-output-escaping="yes">)"&gt;</xsl:text><xsl:value-of select="$elementName"/><xsl:text>&lt;/a&gt;</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text disable-output-escaping="yes">&lt;a href="</xsl:text><xsl:value-of select="$elementsPath"/><xsl:text disable-output-escaping="yes">" target="classFrame" &gt;</xsl:text><xsl:value-of select="$elementName"/><xsl:text>&lt;/a&gt;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="ImportCSS">
		
		<xsl:variable name="currPref">
			<xsl:call-template name="GetCurrentPrefix"/>
		</xsl:variable>
		<xsl:text disable-output-escaping="yes">&lt;STYLE TYPE="text/css"&gt;@import "</xsl:text>
		<xsl:value-of select="concat($currPref, $cssFileName)"/>
		<xsl:text disable-output-escaping="yes">";&lt;/STYLE&gt;</xsl:text>
	</xsl:template>
	
</xsl:stylesheet>
